/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package Chapter11.ordering;

import java.time.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * @author Matthew Gregory
 */
public class StartHere {

    public static void main(String[] args) {
        DataSource myInstances = new DataSource();

        Meeting followupMeeting = myInstances.meetings.get("followupMeeting");

        //Ordering a Set of Strings
        //create a set of names of attendees.
//        Set<String> names = new HashSet<>();
        //Try a TreeSet implementation
        Set<String> names = new TreeSet<>();
        //populate the set with the host and the attendees
        names.add(followupMeeting.host.getFullName());
        for (Person p : followupMeeting.attendees) {
            names.add(p.getFullName());
        }
        //What order are they in?
//        System.out.println("Names: " + names);
        
        //Can we create a ordered Set of people?
//        Set<Person> attendees = new TreeSet<>();
//        attendees.add(followupMeeting.host);
//        for (Person p : followupMeeting.attendees) {
//            attendees.add(p);
//        }
//        System.out.println("Attendees: " + attendees);

        //Testing the changes to Meeting and DataSource
//        System.out.println("Attendees of the followupMeeting: "+followupMeeting.attendees);
//        System.out.println("People in our data source: "+myInstances.people);
        
        //Using the Comparators
        //Sort by last name
//        Set<Person> attendees = new TreeSet<>(new CompareBySurname());
//        attendees.add(followupMeeting.host);
//        for (Person p : followupMeeting.attendees) {
//            attendees.add(p);
//        }
//        System.out.println("Attendees: " + attendees);
        
        //Sort by birthday
//        Set<Person> attendees = new TreeSet<>(new CompareByBirthday());
//        attendees.add(followupMeeting.host);
//        System.out.println("Birthday for "+followupMeeting.host.getFullName()
//                +" is "+followupMeeting.host.birthday);
//        for (Person p : followupMeeting.attendees) {
//            attendees.add(p);
//                    System.out.println("Birthday for "+p.getFullName()
//                +" is "+p.birthday);
//        }
//        System.out.println("Attendees: " + attendees);

        //Ordering a List
        //Create a List based on the attendees
//        List<Person> attendees = new ArrayList<>();
//        attendees.add(followupMeeting.host);
//        for (Person p : followupMeeting.attendees) {
//            attendees.add(p);
//        }
//        System.out.println("Attendees (unsorted) : " + attendees);
        
        //Sort the List
//        attendees.sort(new CompareBySurname());
//        System.out.println("Attendees (sorted) : " + attendees);

        //Soring an array
//        //Convert our set of peple into an array.
//        Person[] people =new Person[3];
//        myInstances.people.values().toArray(people);
//        //Print the array so we can see the initial ordering
//        System.out.println("Before Sorting: ");
//        for (Person p:people){
//            System.out.println(p);
//        }
//        //Sort the array
//        Arrays.sort(people,new CompareBySurname());
//        //Print the array after sorting
//        System.out.println("After Sorting: ");
//        for (Person p:people){
//            System.out.println(p);
//        }
    }
}
